using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_ModelDataOzoneChina : UserControl
    {
        public uc_ModelDataOzoneChina()
        {
            InitializeComponent();            
        }

        string path = "";

        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20191119
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina = new ModelDataOzoneChina();
                txtScenarioName.Text = "";
                cboCMAQOzone.Checked = false;
                if (CommonClass.dicExampleConfiguration != null)
                {
                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["Ozone"]["baselineModelDataFile"];// Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2013_YRD.csv";
                    txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["Ozone"]["forecastModelDataFile"];//Application.StartupPath + @"\Data\SampleData\SMAT-China\Model_O3_Seasonal_2017_YRD.csv";
                    txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
                }
            }
            else
            {
                cboCMAQOzone.Checked = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.doInputfromCmaq;
                txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.scenarioName;
                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.baselineModelDataFile;
                txtBaselineOzone.Text = Path.GetFileName(CommonClass.baseModelFile);
                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as OzoneAnalysisChinaConfiguration).modelDataOzoneChina.forecastModelDataFile;
                txtForecastOzone.Text = Path.GetFileName(CommonClass.futureModelFile);
            }
        }


        private void btnBaselineChina_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog open = new OpenFileDialog();
                //initial directory (1)path (2)default file (3)\Data\SampleData\
                if (string.IsNullOrEmpty(path) || !Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.baseModelFile) || !Directory.Exists(Path.GetDirectoryName(CommonClass.baseModelFile)))
                    {
                        open.InitialDirectory = Application.StartupPath + @"\Data\SampleData\";
                    }
                    else
                    {
                        open.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                    }
                }
                else
                    open.InitialDirectory = path;
                open.Title = LanguageOld.Translate("Select file...");
                open.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (open.ShowDialog() == DialogResult.OK)
                {                    
                    //default file = open.FileName;
                    CommonClass.baseModelFile = open.FileName;
                    txtBaselineOzone.Text = Path.GetFileName(open.FileName);
                    path = Path.GetDirectoryName(open.FileName);
                    open.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnForecastChina_Click(object sender, EventArgs e)
        {
            OpenFileDialog open = new OpenFileDialog();
            //initial directory (1)path (2)default file (3)\Data\SampleData\
            if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
            {
                if (string.IsNullOrEmpty(CommonClass.futureModelFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.futureModelFile)))
                {
                    open.InitialDirectory = Application.StartupPath + @"\Data\SampleData\";
                }
                else
                {
                    open.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                }
            }
            else
                open.InitialDirectory = path;
            open.Title = LanguageOld.Translate("Select file...");
            open.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
            if (open.ShowDialog() == DialogResult.OK)
            {                
                //default file = open.FileName;
                CommonClass.futureModelFile = open.FileName;
                txtForecastOzone.Text = Path.GetFileName(open.FileName);
                path = Path.GetDirectoryName(open.FileName);
                open.RestoreDirectory = true;
            }
        }
    }
}
